﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using GameNetwork;
using hive;


public class BannerData {
    private string pid = "";
    private string  imageUrl = "";

    private Sprite sprite;

    public BannerData(PromotionBannerInfo bannerInfo) {
        pid = bannerInfo.pid.ToString();
        imageUrl = bannerInfo.imageUrl;


        ImageRequest.Instance.Request(imageUrl, (bool success, Sprite _sprite) => {
            if (success) {
                sprite = _sprite;
            } else {
                sprite = null;
            }
        });
    }

    public bool showBanner(GameObject bannerObject) {
        if (sprite == null) {
            return false;
        }

        Image imageComponent = bannerObject.GetComponent<Image> ();
        Button buttonComponent = bannerObject.GetComponent<Button> ();

        imageComponent.sprite = sprite;
        buttonComponent.onClick.RemoveAllListeners();
        buttonComponent.onClick.AddListener(() => {
            onClickBanner();
        });

        bannerObject.SetActive(true);
        
        return true;
    }

    private void onClickBanner() {
        Promotion.showCustomContents(PromotionCustomType.DIRECT, pid, (ResultAPI ResultAPI, PromotionEventType promotionEventType) => {
            // result
        });
    }
}

public class BannerManager : MonoBehaviour
{

    public GameObject bannerObject;
    private List<BannerData> bannerDatas = new List<BannerData>();


    private float time = 0;
    private int nowShowBanner = -1;

    // Start is called before the first frame update
    void Start()
    {
        #if UNITY_EDITOR
        setTestBannerInfomations();
        #else
            HIVEManager.shared.promotionGetBannerInfo(onHIVEManagerGetBannerInfo);
        #endif
    }

    // Update is called once per frame
    void Update()
    {
        if (bannerDatas.Count > 0) {
            if (nowShowBanner == -1) {
                // Show Banner 시작
                int bannerNumber = 0;
                if (bannerDatas[bannerNumber].showBanner(bannerObject) ) {
                    nowShowBanner = bannerNumber;
                }
            } else {
                if (time > 5) {
                    // banner 이미지 바꾸기
                    int bannerNumber = (nowShowBanner + 1) % bannerDatas.Count;
                    if (bannerDatas[bannerNumber].showBanner(bannerObject)) {
                        nowShowBanner = bannerNumber;
                        time = 0;
                    }
                } else {
                    time += Time.deltaTime;
                }
            }
        }
    }

    void onHIVEManagerGetBannerInfo(bool isSuccess, List<PromotionBannerInfo> bannerList) {
        Debug.Log("onHIVEManagerGetBannerInfo");
        foreach (PromotionBannerInfo bannerInfo in bannerList) {
            Debug.Log(bannerInfo.toString());
            BannerData bannerData = new BannerData(bannerInfo);
            bannerDatas.Add(bannerData);
        }
    }
    private void setTestBannerInfomations() {

        // Banner 1
        PromotionBannerInfo promotionBannerInfo1 = new PromotionBannerInfo();
        promotionBannerInfo1.imageUrl = "https://sandbox-image-glb.qpyou.cn//hivepromotion/banner/1910/2963_1572421144_01_main_10_banner_1.png";
        promotionBannerInfo1.pid = 203397;      // for sandbox server
        Debug.Log(promotionBannerInfo1.toString());

        BannerData bannerData1 = new BannerData(promotionBannerInfo1);
        bannerDatas.Add(bannerData1);

        // Banner 2
        PromotionBannerInfo promotionBannerInfo2 = new PromotionBannerInfo();
        promotionBannerInfo2.imageUrl = "https://sandbox-image-glb.qpyou.cn//hivepromotion/banner/1910/9205_1572421265_01_main_11_banner_2.png";
        promotionBannerInfo2.pid = 203396;      // for sandbox server
        Debug.Log(promotionBannerInfo2.toString());

        BannerData bannerData2 = new BannerData(promotionBannerInfo2);
        bannerDatas.Add(bannerData2);
        
    }

}
